package ru.yandex.tours.tools.lt

import java.io.File

import ru.yandex.tours.model.BaseModel.Point
import ru.yandex.tours.model.hotels.HotelsHolder.{Feature, Hotel}
import ru.yandex.tours.model.hotels.Star
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.parsing._

import scala.collection.JavaConversions._

class LtUpdateMerger(files: Iterable[File]) {
  case class UpdateInfo(id: String, newAddress: String, newPhone: String, newStars: String, lon: String, lat: String, url: String, distanceToBeach: String, beachLine: String, beachType: String)
  
  val updates = files.flatMap(file => IO.readLines(file).map {
//    id	new_address	new_phone	new_stars	new_lon	new_lat	new_hotel_url	new_distance_beach_meters	new_beach_line	new_beach_type
//    id	new_address	new_phone	new_stars	new_lon	new_lat	new_hotel_url	new_distance_beach_meters	new_beach_line	new_beach_type	end
    case Tabbed(id, newAddress, newPhone, newStars, lon, lat, url, distanceToBeach, beachLine, beachType, "end") =>
      id -> UpdateInfo(id, newAddress, newPhone, newStars, lon, lat, url, distanceToBeach, beachLine, beachType)
  }).toMap

  def merge(hotel: Hotel): Hotel = {
    updates.get(hotel.getLocalId) match {
      case Some(UpdateInfo(id, newAddress, newPhone, newStars, lon, lat, url, distanceToBeach, beachLine, beachType)) =>
        val builder = hotel.toBuilder
        if (newAddress.nonEmpty) {
          val addresses = builder.getAddressList.map(address => address.toBuilder.setFullAddress(newAddress).build)
          builder.clearAddress().addAllAddress(asJavaIterable(addresses))
        }
        if (newPhone.nonEmpty) {
          builder.clearPhone().addPhone(newPhone)
        }
        if (newStars.nonEmpty) {
          builder.clearStars().setStars(Star.getStar(newStars).id)
        }
        if (lon.nonEmpty && lat.nonEmpty) {
          val point = Point.newBuilder().setLongitude(lon.toDouble).setLatitude(lat.toDouble)
          builder.setPoint(point)
        }
        if (url.nonEmpty) {
          builder.setHotelUrl(url)
        }
        if (distanceToBeach.nonEmpty) {
          updateFeature(builder, "distance_to_beach", distanceToBeach)
        }
        if (beachLine.nonEmpty) {
          val line = beachLine match {
            case "BEACH_LINE_FIRST" => "1"
            case "BEACH_LINE_SECOND" => "2"
            case "BEACH_LINE_THIRD" => "3"
            case _ => throw new Exception("Unknown beach line! " + beachLine)
          }
          updateFeature(builder, "hotel_line", line)
        }
        if (beachType.nonEmpty) {
          val `type` = beachType match {
            case "BEACH_TYPE_MIXED_PEBBLE_SANDY" => "mixed_sand_pebble"
            case "BEACH_TYPE_PEBBLE" => "pebble"
            case "BEACH_TYPE_SANDY" => "sand"
            case "BEACH_TYPE_PLATFORM" => "platform"
            case _ => throw new Exception("Unknown beach type: " + beachType)
          }
          updateFeature(builder, "beach", `type`)
        }
        builder.build()
      case _ => hotel
    }
  }

  private def updateFeature(builder: Hotel.Builder, name: String, value: String) = {
    val features = builder.getFeaturesList.filter(_.getName != name) ++ Seq(Feature.newBuilder().setName(name).setValue(value).build())
    builder.clearFeatures().addAllFeatures(asJavaIterable(features))
  }
}
