package ru.yandex.tours.tools.lt

import java.io.{File, FileOutputStream}

import ru.yandex.tours.hotels.HotelIO
import ru.yandex.tours.util.parsing.{IntValue, Tabbed}

import scala.collection.JavaConversions._
import scala.collection.mutable

object ManualTolokaMerging extends App {
  def readMatching(filename: String) = {
    scala.io.Source.fromFile(filename).getLines().map {
      case Tabbed(IntValue(5), ltId, IntValue(partner), id) => (partner, id) -> ltId
    }.toMap
  }

  val sameToloka = readMatching("same.toloka.tsv")
  val diffToloka = readMatching("different.toloka.tsv")
  val merging = readMatching("same.merging.tsv")

  var ltHotels = HotelIO.loadFromFile(new File("new_hotels.proto")).map(h => h.getLocalId -> h).toMap
  println("Total lt size: " + ltHotels.size)

  def getCandidate(pair: (Int, String)): Option[String] = sameToloka.get(pair).orElse(merging.get(pair))

  val matchedLt = mutable.HashSet.empty[String]

  val finalHotels = HotelIO.loadFromFileAsIterator(new File("final.hotel.proto")).flatMap { hotel =>
    (hotel :: hotel.getChildrenList.toList).find {
      child =>
        val tuple = (child.getPartnerId, child.getLocalId)
        getCandidate(tuple).isDefined && diffToloka.get(tuple).isEmpty
    }.flatMap(h => getCandidate((h.getPartnerId, h.getLocalId))) match {
      case Some(ltId) =>
        matchedLt += ltId
        val head = ltHotels(ltId).toBuilder
        val child = hotel.toBuilder
        head.addAllChildren(child.getChildrenList).addChildren(child.clearChildren)
        val result = head.build
        ltHotels += ltId -> result
        None
      case None => Some(hotel)
    }
  }

  val os = new FileOutputStream("hotels.proto")
  for (hotel <- finalHotels) hotel.writeDelimitedTo(os)
  println("Matched lt: " + matchedLt.size)
  for {
    hotel <- ltHotels.values
  } {
    hotel.writeDelimitedTo(os)
  }

  os.close()

}
