package ru.yandex.tours.tools.merging

import java.io.FileOutputStream
import java.util.concurrent.atomic.AtomicInteger

import ru.yandex.tours.db.GridPoint
import ru.yandex.tours.db.dao.HotelsDao
import ru.yandex.tours.db.dao.HotelsDao.InGridPoint
import ru.yandex.tours.tools.{TestDb, Tool}
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.lang.Futures._

import scala.concurrent.ExecutionContext.Implicits.global
import scala.util.Failure

object HotelForCorpusExtractor extends Tool with CorpusAware with TestDb {
  val interestingIds = readCorpuses(allCorpuses: _*).flatMap(x => Set(x.master, x.slave)).toSet

  val dao = new HotelsDao(prodDb)

  val f = dao.get(interestingIds).andThen {
    case Failure(e) => e.printStackTrace()
  }

  val hotels = f.await_!
  println(s"loaded ${hotels.size} hotels")

  val points = hotels.map(_.hotel.getRawHotel.getPoint)
    .map(GridPoint.fromPoint).flatMap(_.nearPoints).distinct

  val toLoad = dao.count(InGridPoint(points: _*)).await_!
  println(toLoad + " hotels will be loaded")
  IO.using(new FileOutputStream("corpus_hotels.proto")) { os ⇒
    val found = new AtomicInteger()
    dao.traverse(InGridPoint(points: _*)) {
      hotel ⇒
        val i = found.incrementAndGet
        if (i % 1000 == 0) println(i + " / " + toLoad)
        hotel.hotel.writeDelimitedTo(os)
    }.await_!
    println(found)
  }


//  val hotels = ProtoIO.loadFromFile(new File("partner_hotels.proto"), PartnerHotel.PARSER)
//                      .filter(h => interestingIds.contains(h.getId))
//  ProtoIO.dump("corpus_hotels.proto", hotels)
}
