package ru.yandex.tours.tools.merging

import java.io.File

import ru.yandex.extdata.common.service.ExtDataService
import ru.yandex.extdata.provider.cache.LocalFSDataCache
import ru.yandex.extdata.provider.{HttpExtDataClient, RemoteExtDataService}
import ru.yandex.tours.extdata.{DataTypes, ExtDataUpdateChecker}
import ru.yandex.tours.hotels.{HotelRatings, ShardedYoctoHotelsIndex}
import ru.yandex.tours.indexer.clusterization.Grid
import ru.yandex.tours.model.hotels.HotelsHolder.PartnerHotel
import ru.yandex.tours.util.naming.TfIdfModel

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 20.04.16
 */
object LocalHotelsIndex {
  private lazy val extDataClient = new HttpExtDataClient("http://localhost:36445", 4, 10000)

  private lazy val localFSCache = {
    new File("tours-data/cache").mkdirs()
    val cache = new LocalFSDataCache(
      DataTypes.registry,
      extDataClient,
      "tours-data/cache",
      false
    )
    cache.afterPropertiesSet()
    cache
  }

  lazy val extDataService: ExtDataService = new RemoteExtDataService(localFSCache)
  lazy val shardedHotelsIndex = ShardedYoctoHotelsIndex.fromExtData(
    new File("tours-data/hotels_index"),
    HotelRatings.from(extDataService),
    extDataService,
    ExtDataUpdateChecker.empty,
    lazyLoadResources = false
  )

  lazy val tfIdf = TfIdfModel.parse(extDataService.readData(DataTypes.hotelsTfIdfModel))
}
