package ru.yandex.tours.tools.merging

import java.io.FileOutputStream

import ru.yandex.tours.hotels.HotelIO
import ru.yandex.tours.model.hotels.HotelsHolder.Hotel
import ru.yandex.tours.tools.Tool
import ru.yandex.tours.util.IO

object ManualClusterization extends Tool {
  val slave2master = Map(
    1909001 -> 1017335,
    1908982 -> 1017335,
    1909012 -> 1017335,
    1908767 -> 1000392,
    1908750 -> 1000407,
    1908754 -> 1000409,
    1908777 -> 1000398,
    1908883 -> 1908882,
    1908764 -> 1000397,
    1909004 -> 1013768,
    1908815 -> 1000403,
    1908900 -> 1017338,
    1908787 -> 1018688,
    1908788 -> 1018688,
    1013399 -> 1000408,
    1018652 -> 1000390,
    1908828 -> 1018527,
    1908904 -> 1000412,
    1908919 -> 1017336,
    2142965 -> 1000411,
    2260165 -> 1000144,
    1908993 -> 1013769,
    1908869 -> 1017332,
    1018675 -> 1000391,
    1908997 -> 1908918,
    1908819 -> 1017340,
    1908990 -> 1908917,
    1909009 -> 1908762
  )

  def rawHotels = HotelIO.loadFromFileAsIterator("patched_geo.proto")

  val masters = slave2master.values.toSet

  val interestingHotels = slave2master.flatMap { case (slave, master) => Set(slave, master) }.toSet


  IO.using(new FileOutputStream("rosa_hutor.proto")) { os =>
    var id2hotel = Map.empty[Int, Hotel]
    rawHotels.foreach { hotel =>
      if (interestingHotels.contains(hotel.getId)) {
        id2hotel += hotel.getId -> hotel
      } else {
        hotel.writeDelimitedTo(os)
      }
    }

    val id2masterBuilder = id2hotel.filter { case (id, _) => masters.contains(id) } map { case (id, hotel) => id -> hotel.toBuilder }
    slave2master.foreach { case (slaveId, masterId) =>
      val slave = id2hotel(slaveId).toBuilder
      val master = id2masterBuilder(masterId)
      master.addAllChildren(slave.getChildrenList)
      master.addChildren(slave.clearChildren())
    }
    id2masterBuilder.values.foreach(_.build.writeDelimitedTo(os))
  }

}
