package ru.yandex.tours.tools.merging

import ru.yandex.tours.hotels.{HotelIO, HotelsUtil}
import ru.yandex.tours.model.hotels.HotelsHolder.Hotel

import scala.collection.mutable

object OldHotelsUpdater extends App {

  val pathForNewHotels = "lt_to_add.proto"
  val pathForUpdateHotels = "lt_updated.proto"
  val oldHotels: TraversableOnce[Hotel] = HotelIO.loadFromFileAsIterator("lt.update.proto")
  val newHotels: Map[(Int, String), Hotel] = HotelIO.loadFromFileAsIterator("lt.hotels.proto").map { hotel =>
    (hotel.getPartnerId, hotel.getLocalId) -> hotel
  }.toMap
  val used = mutable.Set.empty[Hotel]

  def update(builder: Hotel.Builder): Unit = {
    newHotels.get((builder.getPartnerId, builder.getLocalId)).foreach { newHotel =>
      used += newHotel
      builder
        .clearName()
        .clearAddress()
        .clearPoint()
        .clearStars()
        .clearFeatures()
        .clearHotelUrl()
        .clearPartnerUrl()
        .clearPhotos()
        .clearGeoId()
        .clearRating()
        .clearReviewsCount()
        .clearPhone()
        .clearSynonyms()
        .clearImages()

      builder.addAllName(newHotel.getNameList)
      builder.addAllAddress(newHotel.getAddressList)
      if (newHotel.hasPoint) builder.setPoint(newHotel.getPoint)
      if (newHotel.hasStars) builder.setStars(newHotel.getStars)
      builder.addAllFeatures(newHotel.getFeaturesList)
      if (newHotel.hasHotelUrl) builder.setHotelUrl(newHotel.getHotelUrl)
      if (newHotel.hasPartnerUrl) builder.setPartnerUrl(newHotel.getPartnerUrl)
      builder.addAllPhotos(newHotel.getPhotosList)
      builder.setGeoId(newHotel.getGeoId)
      if (newHotel.hasRating) builder.setRating(newHotel.getRating)
      if (newHotel.hasReviewsCount) builder.setReviewsCount(newHotel.getReviewsCount)
      builder.addAllPhone(newHotel.getPhotosList)
      builder.addAllSynonyms(newHotel.getSynonymsList)
      builder.addAllImages(newHotel.getImagesList)
    }
  }

  val updatedHotels = HotelsUtil.updateHotels(oldHotels, update)
  HotelIO.dumpToFile(updatedHotels, pathForUpdateHotels)
  val hotelsToAdd = newHotels.values.filter(!used.contains(_))
  HotelIO.dumpToFile(hotelsToAdd, pathForNewHotels)
  println(s"Updated hotels: ${used.size}")
  println(s"Hotels to add: ${newHotels.size - used.size}")
}
