package ru.yandex.tours.tools.merging

import akka.actor.ActorSystem
import com.typesafe.config.ConfigFactory
import ru.yandex.tours.db.dao.HotelsDao
import ru.yandex.tours.indexer.clusterization.similarity.{CombinedSimilarity, DistanceThresholdSimilarity, ShingleSimilarity}
import ru.yandex.tours.indexer.clusterization.{Grid, HotelClusterizer, ThresholdClusterizer, ThresholdClusterizerFactory}
import ru.yandex.tours.model.hotels.HotelsHolder.PartnerHotel
import ru.yandex.tours.tools.TestDb
import ru.yandex.tours.util.Logging

import scala.concurrent.duration._

object ThresholdClusterizerTool extends App with TestDb with Logging {

  implicit val as = ActorSystem("clusterization", ConfigFactory.empty())
  implicit val ec = as.dispatcher

  val dao = new HotelsDao(testDb)
  val clusterizer = new ThresholdClusterizerFactory()
  val task = new HotelClusterizer(testDb, dao, clusterizer, 10.hours)
  task.run().onComplete(println)

}
