package ru.yandex.tours.tools.merging.corpus

import ru.yandex.tours.app.{AkkaSupport, Application, DefaultEnvironment}
import ru.yandex.tours.db.dao.HotelsDao
import ru.yandex.tours.db.dao.HotelsDao.OnlyPartner
import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.tools.TestDb
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.parsing.Tabbed

import scala.collection.JavaConverters._

object Hotels101MatchingExtractor extends Application
  with TestDb
  with DefaultEnvironment
  with AkkaSupport {

  implicit val ec = akkaSystem.dispatcher
  val dao = new HotelsDao(prodDb)

  dao.retrieveRafMap(OnlyPartner(Partners.hotels101)).map { map =>
    IO.printFile("ipython/101hotels_corpus.tsv") { pw =>
      for {
        hotel <- map.valuesIterator
        addInfo <- hotel.getRawHotel.getAddInfoList.asScala
        if addInfo.getName == "YandexID"
      } {
        pw.println(Tabbed(hotel.getId, addInfo.getValue, "1"))
      }
    }
    map.close()
  }.andThen {
    case x => println(x)
  }.onComplete {
    case _ => sys.exit()
  }

}
