package ru.yandex.tours.tools.merging.corpus

import ru.yandex.tours.db.tables.Clusterization
import ru.yandex.tours.db.tables.LinkType.LinkType
import ru.yandex.tours.tools.{TestDb, Tool}
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.parsing.Tabbed

import scala.collection.mutable
import scala.concurrent.duration._
import scala.concurrent.Await
import scala.concurrent.ExecutionContext.Implicits.global

object ManualAdminMatchingExtractor extends Tool with TestDb {

  val f = Clusterization.retrieveClusterLinks(1, prodDb, "Tool").map { links =>
    val map = mutable.HashMap.empty[(Int, Int), LinkType]
    links.filter(_.isManual).sortBy(_.timestamp).foreach { link =>
      map.put((link.child, link.parent), link.`type`)
    }
    IO.printFile("data/manual_admin_corpus.tsv") { pw =>
      map.foreach {
        case ((from, to), lt) => pw.println(Tabbed(from, to, 1 - lt.id))
      }
    }
  }.andThen {
    case x => println(x)
  }

  Await.result(f, 1.hour)
}
