package ru.yandex.tours.tools.osm

import java.io.{File, PrintWriter}

import ru.yandex.tours.geo
import ru.yandex.tours.hotels.HotelIO
import ru.yandex.tours.model.Languages
import ru.yandex.tours.tools.Tool
import ru.yandex.tours.util.parsing.Tabbed

object OsmRegionMatcher extends Tool {
  val interestingGeoIds = {
    val hotelGeoIds = HotelIO.loadFromFileAsIterator(new File("lt_final.proto")).map(_.getGeoId)
          hotelGeoIds.toSet ++
    geoMapping.countryGeoIds ++
      geoMapping.cityGeoIds ++
      geoMapping.departuresGeoIds
  }

  private def osmFilter(osmObject: OsmObject) = {
//    osmObject.`type` == "administrative" && osmObject.clazz == "boundary"
    true
  }

  val enOsm = parseOsm(Languages.en, osmFilter)
  val ruOsm = parseOsm(Languages.ru, osmFilter)

  val pw = new PrintWriter("osm_region_match.tsv")
  val emptyMatchPw = new PrintWriter("osm_empty_region_match.tsv")
  val osmBounderies = new PrintWriter("osm_boundaries.tsv")
  interestingGeoIds.foreach { geoId =>
    val region = tree.region(geoId).get
    val candidates = (enOsm.getOrElse(geoId, Seq.empty) ++ ruOsm.getOrElse(geoId, Seq.empty)).filter(osm => geo.distanceInKm(osm.lat, osm.lon, region.latitude, region.longitude) < 51)
    if (candidates.isEmpty) {
      emptyMatchPw.println(geoId)
    } else {
      val best = candidates.toSeq.sortBy(osm => -(similarity(osm, geoId, tree) * 10 + (if (osm.hasPolygon) 1 else 0))).head
      val fullname = tree.pathToRoot(region).map(_.name(Languages.ru)).mkString(", ")
      pw.println(Tabbed(geoId, fullname, best.url, best.osmType, best.id))
      osmBounderies.println(Tabbed(geoId, best.rectangle.toTsv))
    }
  }

  osmBounderies.close()
  emptyMatchPw.close()
  pw.close()
}
