package ru.yandex.tours.tools.osm


import ru.yandex.tours.geo.base.Region
import ru.yandex.tours.model.Languages
import ru.yandex.tours.tools.Tool
import ru.yandex.tours.tools.osm.MemberTypes.MemberType
import ru.yandex.tours.util.Collections._
import ru.yandex.tours.util.parsing._

object OsmToGeobaseMatcher extends Tool {

  type Tags = Iterable[(String, String)]

  case class Node(id: Long, lon: Double, lat: Double, tags: Tags) {
    def get(name: String) = tags.find(_._1 == name).get._2

    def has(name: String) = tags.exists(_._1 == name)
  }

  case class Member(id: Long, `type`: MemberType, role: String)

  case class Relation(id: Int, members: Iterable[Member], tags: Tags)

  case class Way(id: Long, members: Iterable[Long], tags: Tags)


  def parseNodes(fileName: String, fits: Tags => Boolean) = {
    scala.io.Source.fromFile(fileName).getLines().map {
      case Tabbed(LongValue(id), DoubleValue(lon), DoubleValue(lat), AtSKV(tags)) => Node(id, lon, lat, tags)
      case line => throw new Exception(s"Can not parse node: $line")
    }.filter(node => fits(node.tags))
  }

  val nodes = parseNodes("/Users/berkut/projects/osm_test/nodes.osm.tsv", tags => tags.exists(_._1 == "place")).toList

  val name2node = nodes.filter(_.has("name")).map(n => n.get("name") -> n).toMultiMap

  val austria = tree.region(113).get

  private def getAllChildren(region: Region): List[Region] = region :: tree.children(region).toList.flatMap(getAllChildren)

  getAllChildren(austria).foreach { region =>
    val candidates = region.allNames.flatMap(name2node.get).flatten
    println(Tabbed(region.id, region.name(Languages.en), candidates.size))
  }

}
