package ru.yandex.tours.tools.s3

import java.io.PrintWriter

import scala.concurrent.ExecutionContext.Implicits.global
import ru.yandex.tours.app._
import ru.yandex.tours.util.IO


trait S3FileUploadTrait extends DefaultEnvironment with AkkaSupport  with DefaultHttpSupport with S3Support {
  app : Application =>
}

object S3FileUploadTool extends Application with S3FileUploadTrait {
  private val f = IO.usingTmp("tmp1") { os =>
    IO.using(new PrintWriter(os)) { pw =>
      pw.print("Hello from crush")
    }
  }
  for {
    (sc, entity) <- s3Client.uploadFile("Example2.txt", f)
  } yield {
    System.out.println(s"Status: $sc, entity $entity")
  }
}
