package ru.yandex.tours.tools.sodis

import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.tools.Tool
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.parsing.Tabbed

object SodisDeparturesTool extends Tool {
  IO.printFile("sodis_departures.tsv") { pw =>
    for {
      geoId <- geoMapping.departuresGeoIds
      sodisId <- geoMapping.getPartnerCity(Partners.sodis, geoId).toIterable
    } {
      pw.println(Tabbed(Partners.sodis.id, geoId, sodisId))
    }
  }
}
