package ru.yandex.tours.tools.sodis

import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.tools.Tool
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.parsing.Tabbed

import scala.collection.JavaConversions._

object SodisMatchingFilterTool extends Tool {

  val knownSodis = (for {
    hotel <- hotels("lt_merged.proto")
    child <- hotel :: hotel.getChildrenList.toList
    if child.getPartnerId == Partners.sodis.id
  } yield child.getLocalId).toSet

  IO.printFile("sodis_new_to_yandex.tsv") { pw =>
    IO.readLines("sodis_to_yandex.tsv").filter {
      case line@Tabbed(_, _, _, _, _, _, localId, _, _, _, _) => knownSodis.contains(localId)
    }.foreach(pw.println)
  }

}
