package ru.yandex.tours.tools.sunmar

import java.io.PrintWriter
import java.text.DecimalFormat

import org.apache.cxf.transport.common.gzip.GZIPFeature
import ru.yandex.common.util.StringEscapeUtils
import ru.yandex.tours.model.hotels.{Partners, Star}
import ru.yandex.tours.partners.sunmar.{OTICredential, SearchService, DefaultSunmarClient}
import ru.yandex.tours.util.IO

import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.duration._
import scala.concurrent.{Await, Future}
import scala.util.control.NonFatal

//import javax.xml.namespace.QName

//import ru.yandex.tours.partners.sunmar.{OTICredential, SearchServiceLocator}

/* To Generate wsdl use smth like that:
   /System/Library/Java/JavaVirtualMachines/1.6.0.jdk/Contents/Home/bin/java -classpath /Users/berkut/.ivy2/cache/wsdl4j/wsdl4j/jars/wsdl4j-1.6.2.jar:/Users/berkut/.ivy2/cache/javax.xml/jaxrpc-api/jars/jaxrpc-api-1.1.jar:/Users/berkut/.ivy2/cache/org.apache.axis/axis/jars/axis-1.4.jar:/Users/berkut/.ivy2/cache/org.slf4j/log4j-over-slf4j/jars/log4j-over-slf4j-1.7.7.jar:/Users/berkut/projects/tours/project/target/idea-classes:/Users/berkut/.ivy2/cache/org.slf4j/jcl-over-slf4j/jars/jcl-over-slf4j-1.7.7.jar:/Users/berkut/.ivy2/cache/commons-discovery/commons-discovery/jars/commons-discovery-0.5.jar:/Users/berkut/.ivy2/cache/org.slf4j/slf4j-api/jars/slf4j-api-1.7.7.jar -Xmx128M org.apache.axis.wsdl.WSDL2Java -pru.yandex.tours.partners.sunmar -T1.1 -o/Users/berkut/projects/tours/tours-tools/src/main/generated file:///Users/berkut/projects/tours/sunmar.wsdl
  Don't forget to use your pathes.
*/
object SunmarHotelsTool extends App {
  val myFormatter = new DecimalFormat("###.#####")

  val searchService = new SearchService().getBasicHttpEndpoint(
    new GZIPFeature()
    //    ,new LoggingFeature("<stdout>", "<stdout>")
  )
  val cred = new OTICredential

  cred.setUsername("Yandex")
  cred.setPassword("65536")

  val client = new DefaultSunmarClient(searchService, cred)

  val hotelsF = for {
    countries <- client.countries
    hotelsSeq <- Future.sequence(countries.map(c => client.hotels(c.getID).map(c -> _)))
  } yield hotelsSeq.toMap

  val hotelsMap = Await.result(hotelsF, 10.minutes)

  IO.using(new PrintWriter("sunmar_hotels.xml")) { out =>
    out.println("<?xml version=\"1.0\" encoding=\"utf-8\"?><companies xmlns:xi=\"http://www.w3.org/2001/XInclude\" version=\"2.1\">")

    for {
      (country, hotels) <- hotelsMap
      hotel <- hotels
    } {
      out.println("<company>")
      out.println(s"<company-id>${hotel.getID}</company-id>")
      out.println("<rubric-id>184106414</rubric-id>")
      out.println(s"<actualization-date>${System.currentTimeMillis()}</actualization-date>")

      val starsStr = hotel.getHotelCategory.getSname
      val stars =
        try Star.stars(starsStr.take(1).toInt).name
        catch {case NonFatal(_) => Star.stars(0)}
      out.println(s"""<feature-enum-single name="star" value="${stars}"/>""")

      addLangTag("name", "ru", hotel.getLname)
      addLangTag("name", "en", hotel.getName)

      if ((hotel.getWeb ne null) && hotel.getWeb.nonEmpty) {
        out.println(s"<url>${StringEscapeUtils.escapeXml(hotel.getWeb)}</url>")
      }

      if (hotel.getLatitude.nonEmpty && hotel.getLongitude.nonEmpty) {
        out.println(s"<coordinates><lat>${myFormatter.format(hotel.getLatitude.toDouble)}</lat><lon>${myFormatter.format(hotel.getLongitude.toDouble)}</lon></coordinates>")
      }

      addLangTag("address", "", hotel.getAddress)

      addLangTag("country", "ru", country.getLname)
      addLangTag("country", "en", country.getName)
      addLangTag("locality-name", "ru", hotel.getPlace.getArea.getLname)
      addLangTag("locality-name", "en", hotel.getPlace.getArea.getName)

      out.print("<add-info>")
      out.print( s"""<partner name="${Partners.sunmar}">""")
      out.print("</partner>")
      out.print("</add-info>")

      out.println("</company>")

      def addLangTag(name: String, lang: String, value: String) = {
        out.println(s"""<$name lang="$lang">${StringEscapeUtils.escapeXml(value)}</$name>""")
      }
    }

    out.println("</companies>")
  }

  sys.exit()
}
