package ru.yandex.tours.tools.wizard

import java.io.{File, FileInputStream, FileOutputStream, PrintWriter}
import java.util.zip.GZIPInputStream

import ru.yandex.tours.extdata.LocalExtDataService
import ru.yandex.tours.query.parser.LocalParserResources
import ru.yandex.tours.testkit.TestData
import ru.yandex.tours.util.file._
import ru.yandex.tours.wizard.geoaddr.GeoAddrPragmatics
import ru.yandex.tours.wizard.parser.{BadQueryReporter, UserRequestParser, WizardRequestParser}
import ru.yandex.tours.wizard.query.{PragmaticsParser, WizardRequest}
import spray.http.Uri

import scala.collection.mutable
import scala.io.Source
import scala.util.control.Breaks._

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 11.02.15
 */
object AmmoTool extends App with TestData {

  private val home = new File("/Users/darl/ammo")

  val geoAddrPragmatics = new GeoAddrPragmatics(data.geoMapping)

  val edl = new LocalExtDataService(new File("tours-data/data/wizard"))
  val resources = new LocalParserResources(edl)
  val pragmaticsParser = new UserRequestParser(
    new PragmaticsParser(???),
    new PragmaticsParser(???),
    new PragmaticsParser(???),
    data.regionTree,
    data.hotelsIndex,
    data.hotelRatings,
    data.geoMapping,
    data.directionsStats
  )
  val departures = data.departures

  val parser = new WizardRequestParser(
    BadQueryReporter.empty,
    geoAddrPragmatics,
    pragmaticsParser,
    departures,
    data.hotelRatings
  )

  val logFile = home / "tours-wizard-http-access.log.2015-07-15.gz"
  val is = new GZIPInputStream(new FileInputStream(logFile))

  val headers = Seq(
    "[Host: csminiback01ht.yandex.net:36430]",
    "[Connection: close]"
  )

  val ammoFull = new PrintWriter(new FileOutputStream(home / "wizard_ammo_full.txt"))
  val ammoWithMarker = new PrintWriter(new FileOutputStream(home / "wizard_ammo_with_marker.txt"))
  val ammoUnique = new PrintWriter(new FileOutputStream(home / "wizard_ammo_unique.txt"))
  val ammoHotels = new PrintWriter(new FileOutputStream(home / "wizard_ammo_hotels.txt"))
  val ammoCommon = new PrintWriter(new FileOutputStream(home / "wizard_ammo_common.txt"))
  val ammoDirection = new PrintWriter(new FileOutputStream(home / "wizard_ammo_direction.txt"))


  headers.foreach(ammoFull.println)
  headers.foreach(ammoWithMarker.println)
  headers.foreach(ammoUnique.println)

  var raw = 0
  var wm = 0
  val uniq = new mutable.HashSet[String]

  val Line = "^\\[(.*)\\].*GET ([^ ]+) \\[.*\\].*$".r

  breakable {
    Source.fromInputStream(is).getLines().foreach {
//      case Tabbed(datetime, _, _, _, _, ip, _, regionId, _, _, reqId, userRequest, geoAddr, _*) =>
      case Line(datetime, rawUri) =>
        val u = Uri.apply(rawUri)
        val rawQuery = u.query
        if (u.path.toString() == "/wizard") {
          val userRequest = rawQuery.get("user_request").orElse(rawQuery.get("text")).get
          val geoAddrBase64 = rawQuery.get("geoaddr").get
          val regionId = rawQuery.get("region_id").get

          val query = Uri.Query(
            "user_request" -> userRequest,
            "geoaddr" -> geoAddrBase64,
            "region_id" -> regionId,
            "tld" -> "ru"
          )
          val uri = "/wizard?" + query.toString()

          if (raw <= 50000) {
            raw += 1
            ammoFull.println(uri)
          }
          val request = parser.parse(WizardRequest(regionId.toInt, userRequest, geoAddrBase64))
          if (request.isDefined) {
            wm += 1
            if (wm <= 50000) {
              ammoWithMarker.println(uri)
            }
            if (!uniq.contains(userRequest)) {
              uniq += userRequest
              ammoUnique.println(uri)
            }
            if (request.get.hotel.isDefined) {
              ammoHotels.println(uri)
            } else if (request.get.to.isDefined) {
              ammoDirection.println(uri)
            } else {
              ammoCommon.println(uri)
            }
          }
          if (uniq.size >= 50000) break()
        }
    }
  }

  ammoFull.close()
  ammoWithMarker.close()
  ammoUnique.close()
  ammoHotels.close()
  ammoCommon.close()
  ammoDirection.close()
}
