#!/bin/bash

ROOT=$1

DAEMON_BASE=tours
DAEMON=tours-warmer

JAVA_HOME=/usr/local/java8
PATH="$JAVA_HOME/bin:$PATH"
LANG=ru_RU.UTF8
LOG_DIR=/var/log/$DAEMON_BASE
HPROF_DIR=$LOG_DIR/hprof/$DAEMON
GC_LOG=$LOG_DIR/$DAEMON-gc.log
LIB_PATH=$ROOT/usr/lib/yandex/$DAEMON/lib

mkdir -p $HPROF_DIR

CLASSPATH=`find $LIB_PATH -name '*.jar' -printf '%p:'`$CLASSPATH
export PATH LANG JAVA_HOME CLASSPATH

LOG_FILE=$LOG_DIR/$DAEMON.log
STDOUT_LOG_FILE=$LOG_DIR/$DAEMON.log.shell
if [ -f $STDOUT_LOG_FILE ] ; then
  mv $STDOUT_LOG_FILE $STDOUT_LOG_FILE.prev
fi

RESTART_MSG="Starting $DAEMON at `date '+%Y-%m-%d %H:%M:%S'`"
echo $RESTART_MSG >> $LOG_FILE
echo $RESTART_MSG > $STDOUT_LOG_FILE
echo "classpath: $CLASSPATH" >> $STDOUT_LOG_FILE

cd $ROOT/etc/yandex/$DAEMON

exec -a "$DAEMON" \
java -classpath $CLASSPATH  \
     -Dfile.encoding=UTF8 \
     -Dtours.tmp.dir=${DAEMON} \
     -showversion -server -Xverify:none \
     -Xmx512m -Xms128m \
     -XX:+UseG1GC \
     -XX:+HeapDumpOnOutOfMemoryError \
     -XX:HeapDumpPath=$HPROF_DIR \
     -XX:OnOutOfMemoryError="echo on oom killing process %p; kill -9 %p" \
     -Xloggc:$GC_LOG \
     -XX:+PrintCommandLineFlags \
     -XX:+PrintGCApplicationStoppedTime \
     -XX:+PrintGCDetails \
     -XX:+PrintGCDateStamps \
     -Dhost.name=`/bin/hostname --fqdn` \
     -Djava.net.preferIPv6Addresses=true \
     -Dsun.net.client.defaultConnectTimeout=10000 \
     -Dsun.net.client.defaultReadTimeout=10000 \
     -Dsun.net.inetaddr.ttl=86400 -Dhttp.keepAlive=false \
     -Dlogging.path=$LOG_DIR \
     ru.yandex.tours.WarmerMain >> $STDOUT_LOG_FILE 2>&1
