#!/bin/sh

DAEMON_BASE=tours
DAEMON=tours-warmer

JAVA_HOME=/usr/local/java7
PATH="$JAVA_HOME/bin:$PATH"
LANG=ru_RU.UTF8
PID_FILE=../$DAEMON.pid
LOG_DIR=.
HPROF_DIR=.
GC_LOG=./$DAEMON-gc.log
LIB_PATH=lib

CLASSPATH=`find $LIB_PATH -name '*.jar' -printf '%p:'`$CLASSPATH
export PATH LANG JAVA_HOME CLASSPATH

exec -a "$DAEMON" \
java -classpath $CLASSPATH  \
     -Dfile.encoding=UTF8 \
     -Doracle.net.tns_admin=/etc/oracle \
     -showversion -server -Xverify:none \
     -Xmx512m -Xms128m \
     -XX:+UseG1GC \
     -XX:+HeapDumpOnOutOfMemoryError \
     -Dhost.name=`/bin/hostname --fqdn` \
     -Djava.net.preferIPv6Addresses=true \
     -Dsun.net.client.defaultConnectTimeout=10000 \
     -Dsun.net.client.defaultReadTimeout=10000 \
     -Dsun.net.inetaddr.ttl=86400 -Dhttp.keepAlive=false \
     -Dlogging.path=$LOG_DIR \
     ru.yandex.tours.WarmerMain >> $DAEMON.log.shell 2>&1 &

echo $! > $PID_FILE
