package ru.yandex.tours

import akka.actor.Props
import ru.yandex.tours.app._
import ru.yandex.tours.clickhouse.{ClickHouseSupport, DefaultClickHouseClient}
import ru.yandex.tours.client.ToursClientImpl
import ru.yandex.tours.extdata.ExtDataSupport
import ru.yandex.tours.prices.ClickHousePriceSearcher
import ru.yandex.tours.services.RemoteToursSearchService
import ru.yandex.tours.storage.subscriptions.SubscriptionsStorageSupport
import ru.yandex.tours.supplier._
import ru.yandex.tours.util.zoo.{DoubleSerializer, SharedValue}

/**
 * Created with IntelliJ IDEA.
 * User: Anton Ivanov <antonio@yandex-team.ru>
 * Date: 06.02.15
 * Time: 13:21
 */
trait WarmerComponents {
  app: Application
    with AkkaSupport
    with SpraySupport
    with ZookeeperSupport
    with HttpSupport
    with ClickHouseSupport
    with MetricsSupport
    with CommonDataHolders
    with ExtDataSupport
    with SubscriptionsStorageSupport =>

  implicit val akka = akkaSystem
  import akkaSystem.dispatcher

  val toursSearchService = RemoteToursSearchService.fromConfig(httpClient, config, "tours")

  val priceSearcher = new ClickHousePriceSearcher(clickHouseClient)

  val rpsValue = new SharedValue(zkClient, "/warmer/rps", 0.1d, DoubleSerializer)

  val subscriptionsSupplier = new SubscriptionsSupplier(
    subscriptionStorage,
    priceSearcher,
    hotelsIndex,
    SerialSupplierBuilder.build
  )

  val suppliers: IndexedSeq[RequestSupplier] = IndexedSeq(
    subscriptionsSupplier,
    RandomWithPrioritySupplierBuilder.build
  )
  val compositeSupplier = new CompositeSupplier(suppliers)


  val filteringSupplier = new FilteringSupplier(
    compositeSupplier, geoMappingHolder, searchSettings
  )

  val requestDispatcher = {
    val props = Props(new RequestDispatcherActor(
      app.metricsRegistry,
      filteringSupplier,
      new ToursClientImpl(toursSearchService),
      true,
      rpsValue
    ))
    akkaSystem.actorOf(props, "request-dispatcher-actor")
  }

  val handlerProps = Props(new WarmerHandler(rpsValue))

  onStart {
    startServer(handlerProps, config.getInt("component.port"))
  }
}
