package ru.yandex.tours

import ru.yandex.tours.util.spray.HttpHandler
import ru.yandex.tours.util.zoo.SharedValue
import spray.http.StatusCodes
import spray.routing.Route

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 25.03.15
 */
class WarmerHandler(rpsValue: SharedValue[Double]) extends HttpHandler {
  override def route: Route = {
    (path("rps") & parameter('value.as[Double])) { value =>
      rpsValue.set(newValue = value)
      complete(StatusCodes.OK, "Set new rps: " + value)
    }
  }
}
