package ru.yandex.tours.client

import org.joda.time.LocalDate
import ru.yandex.tours.model.search.HotelSearchRequest

import scala.util.Try

object RelativeSearchRequest {
  def parse(line: String) = Try {
    val parts = line.split("\t")
    val from = parts(0).toInt
    val to = parts(1).toInt
    val nights = parts(2).toInt
    val when = WarmerDate.parse(parts(3))
    val ages = parts(4).split("#").map(_.toInt)
    val flexWhen = parts(5).toBoolean
    val flexNights = parts(6).toBoolean
    RelativeSearchRequest(from, to, nights, when, ages, flexWhen, flexNights)
  }
}

case class RelativeSearchRequest(from: Int, to: Int, nights: Int, when: WarmerDate, ages: Seq[Int], flexWhen: Boolean, flexNights: Boolean) {
  def toHotelSearchRequest(date: LocalDate = LocalDate.now()): HotelSearchRequest = {
    HotelSearchRequest(
      from,
      to,
      nights,
      when.toLocalDate(date),
      ages,
      flexWhen,
      flexNights
    )
  }

  def serialize: String = {
    Seq(from, to, nights, when.serialize, ages.mkString("#"), flexWhen, flexNights).mkString("\t")
  }
}
