package ru.yandex.tours.client

import akka.actor.{ActorRef, ActorSystem}
import ru.yandex.tours.services.OfferSearchService
import ru.yandex.tours.util.Logging
import ru.yandex.tours.{ErrorSend, SuccessSendFresh, SuccessSendFromCache}

import scala.concurrent.ExecutionContext
import scala.util.{Failure, Success}

/**
 * Created with IntelliJ IDEA.
 * User: Anton Ivanov <antonio@yandex-team.ru>
 * Date: 06.02.15
 * Time: 16:49
 */
class ToursClientImpl(searcher: OfferSearchService)(implicit system: ActorSystem, ec: ExecutionContext) extends ToursClient with Logging {
  override def checkRequest(request: RelativeSearchRequest, actor: ActorRef): Unit = {
    log.info(s"start downloading request $request")
    val f = searcher.search(request.toHotelSearchRequest(), canStartRequest = true, onlyFromLongCache = false).map(result => ClientResult(result.getProgress.getIsFinished))
    f onComplete {
      case Success(clientResult) if clientResult.isFromCache => actor ! SuccessSendFromCache(request)
      case Success(clientResult) => actor ! SuccessSendFresh(request)
      case Failure(ex) => actor ! ErrorSend(ex)
    }
  }
}
