package ru.yandex.tours.supplier

import org.joda.time.DateTime
import ru.yandex.tours.client.RelativeSearchRequest

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 04.11.15
 */
class ByDayRequestSupplier(suppliers: Map[Int, RequestSupplier]) extends RequestSupplier {
  override def nextRequest(current: DateTime): RelativeSearchRequest = {
    suppliers(current.getDayOfWeek).nextRequest(current)
  }
}
