package ru.yandex.tours.supplier

import java.util.concurrent.atomic.AtomicInteger

import org.joda.time.DateTime
import ru.yandex.tours.client.RelativeSearchRequest
import ru.yandex.tours.util.Logging

/**
 * Created with IntelliJ IDEA.
 * User: Anton Ivanov <antonio@yandex-team.ru>
 * Date: 06.02.15
 * Time: 16:28
 */
class CompositeSupplier(suppliers: IndexedSeq[RequestSupplier]) extends RequestSupplier with Logging {
  require(suppliers.nonEmpty, "suppliers must be non empty")

  override def nextRequest(currentDate: DateTime): RelativeSearchRequest = {
    val nextIndex = lastSupplier.incrementAndGet() % suppliers.size
    suppliers(nextIndex).nextRequest(currentDate)
  }

  private[this] val lastSupplier = new AtomicInteger(-1)
}