package ru.yandex.tours.supplier

import org.joda.time.{DateTimeConstants, DateTime}
import ru.yandex.tours.client.RelativeSearchRequest
import ru.yandex.tours.util.Logging

import scala.io.Source
import scala.util.{Failure, Success, Try}

/**
 * Created with IntelliJ IDEA.
 * User: Anton Ivanov <antonio@yandex-team.ru>
 * Date: 10.02.15
 * Time: 10:06
 */
trait FileSupplierBuilder[T <: RequestSupplier] extends Logging {
  def build: RequestSupplier = {
    val res = for (dayOfWeek <- DateTimeConstants.MONDAY to DateTimeConstants.SUNDAY) yield {
      dayOfWeek -> parseFileForDayOfWeek(dayOfWeek)
    }
    new ByDayRequestSupplier(res.toMap)
  }

  def parseFileForDayOfWeek(dayOfWeek: Int): T

  def allLines(name: String): Iterator[String] = {
    log.info(s"try to load file $name...")
    Source.fromInputStream(classOf[RequestSupplier].getClassLoader.getResourceAsStream(name), "UTF-8").getLines()
  }
}