package ru.yandex.tours.supplier

import org.joda.time.DateTime
import ru.yandex.tours.client.RelativeSearchRequest
import ru.yandex.tours.geo.mapping.GeoMappingHolder
import ru.yandex.tours.model.search.SearchType
import ru.yandex.tours.search.settings.SearchSettingsHolder

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 15.02.16
 */
class FilteringSupplier(delegate: RequestSupplier,
                        geoMappings: GeoMappingHolder,
                        searchSettings: SearchSettingsHolder) extends RequestSupplier {

  val MAX_FILTERED = 1000

  def accept(request: RelativeSearchRequest): Boolean = {
    val settings = searchSettings.getRegionSearchSettings(request.to)
    geoMappings.isKnownDestination(request.to) &&
      geoMappings.isDepartureCity(request.from) &&
      settings.isAllowed(SearchType.TOURS)
  }

  override def nextRequest(current: DateTime): RelativeSearchRequest = {
    var result = delegate.nextRequest(current)
    var i = 1
    while (!accept(result)) {
      i += 1
      if (i > MAX_FILTERED) sys.error("Too many requests not matched by predicate")
      result = delegate.nextRequest(current)
    }
    result
  }
}
