package ru.yandex.tours.supplier

import java.util.concurrent.atomic.AtomicInteger

import org.joda.time.DateTime
import ru.yandex.tours.client.RelativeSearchRequest
import ru.yandex.tours.util.lang._

/**
 * Created with IntelliJ IDEA.
 * User: Anton Ivanov <antonio@yandex-team.ru>
 * Date: 10.02.15
 * Time: 10:22
 */
class SerialSupplier(elements: Seq[RelativeSearchRequest]) extends RequestSupplier {
  override def nextRequest(current: DateTime): RelativeSearchRequest = {
    elements(nextIndex.incrementAndGet() % elements.size)
  }

  private[this] val nextIndex = new AtomicInteger(-1)
}


object SerialSupplierBuilder extends FileSupplierBuilder[SerialSupplier] {
  override def parseFileForDayOfWeek(dayOfWeek: Int): SerialSupplier = {
    val fileName = s"serial_$dayOfWeek.txt"
    val lines = allLines(fileName).flatMap(line => {
      (RelativeSearchRequest.parse(line) onFailure {
        case e => log.error(s"Can not parse relative request. Bad line: [$line]: ${e.getMessage}")
      }).toOption
    }).toSeq
    log.info(s"success load file $fileName with ${lines.size} elements")
    new SerialSupplier(lines)
  }
}