package ru.yandex.tours.index

import org.joda.time.LocalDate
import ru.yandex.tours.wizard.resource.WizardResource

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 26.02.15
 */
trait WizardIndex extends WizardResource {
  def find(operatorId: Int, from: Int, to: Int, fromDate: LocalDate, untilDate: LocalDate): WizardIndexIterator

  def iterator: WizardIndexIterator
}

object WizardIndex {
  def empty = new WizardIndex {
    override def iterator: WizardIndexIterator = WizardIndexIterator.empty
    override def find(operatorId: Int, from: Int, to: Int, fromDate: LocalDate, untilDate: LocalDate): WizardIndexIterator =
      WizardIndexIterator.empty
  }
}