package ru.yandex.tours.index

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 04.03.15
 */
abstract class WizardIndexIterator extends WizardIndexItem with Iterator[WizardIndexItem] {
  def next(): WizardIndexItem = {
    doNext()
    this
  }

  var operatorId: Int = -1
  var from: Int = -1
  var to: Int = -1
  var when: Int = -1
  var nights: Int = -1
  var hotelId: Int = -1

  var minPrice: Int = -1
  var pansion: Int = -1

  protected def doNext()
  protected def set(item: WizardIndexItem): Unit = {
    operatorId = item.operatorId
    from = item.from
    to = item.to
    when = item.when
    nights = item.nights
    hotelId = item.hotelId
    minPrice = item.minPrice
    pansion = item.pansion
  }

  override def toList: List[WizardIndexItem] = {
    this.map(WizardIndexItem.apply).toList
  }
}

object WizardIndexIterator {
  val empty = new WizardIndexIterator {
    override def doNext(): Unit = sys.error("EmptyIterator.next")
    override def hasNext: Boolean = false
  }

  def fromIterator(iterator: Iterator[WizardIndexItem]) = iterator match {
    case wii: WizardIndexIterator => wii
    case _ =>
      new WizardIndexIterator {
        override def hasNext: Boolean = iterator.hasNext
        override protected def doNext(): Unit = {
          val head = iterator.next()
          this.set(head)
        }
      }
  }
}