package ru.yandex.tours.index

import ru.yandex.tours.extdata.DataTypes

import scala.util.hashing.MurmurHash3

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 04.03.15
 */
object WizardIndexing {
  val formatVersion = DataTypes.wizardIndex.formatVersion
  val headerSize = 4 * 4
  val recordSize = 4 * 8

  val indexExtension = ".index"

  val topic = "wizard-index"
  val zkPath = "/tours/wizard/index-distribution"

  def toDirection(regionId: Int): Int = regionId | (1 << 31)
  def toHotel(regionId: Int): Int = regionId | (1 << 30)

  def isDirection(to: Int): Boolean = (to & (1 << 31)) > 0

  def shardCount: Int = DataTypes.wizardIndex.count
  def shardId(operatorId: Int, from: Int, to: Int): Int = {
    val hash = MurmurHash3.productHash((operatorId, from, to))
    (hash % shardCount).abs
  }


  object MicroOffers {
    val formatVersion = DataTypes.shardedMicroOffers.formatVersion
    val headerSize = 2 * Integer.BYTES + java.lang.Long.BYTES

    val shardCount = DataTypes.shardedMicroOffers.count
    def shardId(hotelId: Int): Int = (hotelId % shardCount).abs

    val extension = ".microoffers"
    val topic = "wizard-offers"

    val MAX_OFFER_COUNT = 5
  }
}
