package ru.yandex.tours.index.composite

import ru.yandex.tours.index.WizardIndex

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 05.03.15
 */
object CompositeIndex {
  def optimized(indexes: Vector[WizardIndex]): WizardIndex = {
    if (indexes.isEmpty) {
      WizardIndex.empty
    } else if (indexes.size > 2) {
      val (left, right) = indexes.splitAt(indexes.size / 2)
      new PairIndex(CompositeIndex.optimized(left), CompositeIndex.optimized(right))
    } else if (indexes.size == 2) {
      new PairIndex(indexes(0), indexes(1))
    } else {
      new PairIndex(indexes(0), WizardIndex.empty)
    }
  }
}