package ru.yandex.tours.index.composite

import org.joda.time.LocalDate
import ru.yandex.tours.index.{WizardIndex, WizardIndexIterator}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 26.03.15
 */
class PairIndex(left: WizardIndex, right: WizardIndex) extends WizardIndex {
  override def find(operatorId: Int, from: Int, to: Int, fromDate: LocalDate, untilDate: LocalDate): WizardIndexIterator = {
    new PairIndexIterator(
      left.find(operatorId, from, to, fromDate, untilDate),
      right.find(operatorId, from, to, fromDate, untilDate)
    )
  }

  override def iterator: WizardIndexIterator = {
    new PairIndexIterator(left.iterator, right.iterator)
  }
}
