package ru.yandex.tours.index.composite

import ru.yandex.tours.index.{WizardIndexItem, WizardIndexIterator}

import scala.annotation.tailrec

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 26.03.15
 */
class PairIndexIterator(left: WizardIndexIterator, right: WizardIndexIterator) extends WizardIndexIterator {
  import PairIndexIterator.order

  private var min: WizardIndexIterator = _
  private var hl = left.hasNext
  private var hr = right.hasNext
  if (hl) left.next()
  if (hr) right.next()

  @tailrec
  private def advance(): Boolean = {
    if (hl && hr) {
      if (order.lteq(left, right)) {
        if (order.equiv(this, left)) {
          hl = left.hasNext
          if (hl) left.next()
          advance()
        } else {
          min = left
          hl = left.hasNext
          true
        }
      } else {
        if (order.equiv(this, right)) {
          hr = right.hasNext
          if (hr) right.next()
          advance()
        } else {
          min = right
          hr = right.hasNext
          true
        }
      }
    } else if (hl) {
      if (order.equiv(this, left)) {
        hl = left.hasNext
        if (hl) left.next()
        advance()
      } else {
        min = left
        hl = left.hasNext
        true
      }
    } else if (hr) {
      if (order.equiv(this, right)) {
        hr = right.hasNext
        if (hr) right.next()
        advance()
      } else {
        min = right
        hr = right.hasNext
        true
      }
    } else {
      false
    }
  }

  override def hasNext: Boolean = {
    (min ne null) || advance()
  }

  override protected final def doNext(): Unit = {
    require(min ne null, "EmptyPairIterator.next")
    this.set(min)
    if (min.hasNext) min.next()
    min = null
  }
}

object PairIndexIterator {
  private val order = Ordering.ordered[WizardIndexItem]
}