package ru.yandex.tours.index.composite

import org.joda.time.LocalDate
import ru.yandex.tours.index.shard.IndexShard
import ru.yandex.tours.index.{WizardIndexing, WizardIndexIterator, WizardIndex}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 26.08.15
 */
class ShardedIndex(shards: Vector[IndexShard]) extends WizardIndex {
  override def find(operatorId: Int, from: Int, to: Int, fromDate: LocalDate, untilDate: LocalDate): WizardIndexIterator = {
    val i = WizardIndexing.shardId(operatorId, from, to)
    shards(i).find(operatorId, from, to, fromDate, untilDate)
  }

  override def iterator: WizardIndexIterator = {
    CompositeIndex.optimized(shards).iterator
  }
}
