package ru.yandex.tours.index.shard

import java.nio.ByteBuffer

import ru.yandex.tours.index.{WizardIndexIterator, WizardIndexing}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 05.03.15
 */
class IndexShardIterator(buffer: ByteBuffer, private var position: Int, size: Int) extends WizardIndexIterator {
  override def hasNext: Boolean = {
    position < size
  }
  override def doNext(): Unit = {
    buffer.position(position * WizardIndexing.recordSize)
    position += 1

    this.operatorId = buffer.getInt
    this.from = buffer.getInt
    this.to = buffer.getInt
    this.when = buffer.getInt
    this.nights = buffer.getInt
    this.hotelId = buffer.getInt
    this.minPrice = buffer.getInt
    this.pansion = buffer.getInt
  }
}
