package ru.yandex.tours.query;

import ru.yandex.tours.model.hotels.HotelsHolder.HotelType;

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 27.10.15
 */
public enum QueryHotelType {
    HOTEL(HotelType.UNKNOWN),
    RU_HOTEL(HotelType.UNKNOWN),
    HOSTEL(HotelType.HOSTEL),
    APARTMENTS(HotelType.APARTMENTS),
    GUESTHOUSE(HotelType.GUESTHOUSE),
    COTTAGE(HotelType.GUESTHOUSE),
    VILLA(HotelType.VILLA),
    MOTEL(HotelType.MOTEL),
    APARTHOTEL(HotelType.APARTHOTEL),
    CHALET(HotelType.CHALET),
    HOMESTAY(HotelType.HOMESTAY),
    MINI_HOTEL(HotelType.MINI_HOTEL),
    FARMHOUSE(HotelType.FARMHOUSE),
    SANATORIUM(HotelType.SANATORIUM),
    BOARDING_HOUSE(HotelType.BOARDING_HOUSE),
    HOLIDAY_CAMP(HotelType.HOLIDAY_CAMP),
    HOLIDAY_HOUSE(HotelType.SANATORIUM, HotelType.BOARDING_HOUSE, HotelType.HOLIDAY_CAMP), //HOTELS-1414
    ;

    private final HotelType[] searchTypes;

    QueryHotelType(HotelType ...searchType) {
        this.searchTypes = searchType;
    }


    public HotelType[] getSearchTypes() {
        return searchTypes;
    }
}
