package ru.yandex.tours.wizard.microoffer

import ru.yandex.tours.index.WizardIndexing
import ru.yandex.tours.model.wizard.MicroOffer.HotelMicroOffersProto
import ru.yandex.tours.util.Collections

/**
  * Created by asoboll on 01.02.17.
  */
class ShardedMicroOfferIndex(shards: Vector[MicroOfferIndex]) extends MicroOfferIndex {
  override def get(hotelId: Int): Option[HotelMicroOffersProto] = {
    val i = WizardIndexing.MicroOffers.shardId(hotelId)
    shards(i).get(hotelId)
  }

  // does not choose between records with same hotelId
  override def iterator: Iterator[HotelMicroOffersProto] = {
    Collections.mergeSorted(shards.map(_.iterator))(MicroOfferIndex.idOrdering)
  }
}
