package ru.yandex.tours.wizard.resource

import java.io.Closeable

import ru.yandex.tours.util.IO

import scala.concurrent.duration.FiniteDuration

/**
  * Created by asoboll on 25.01.17.
  */
trait WizardResource extends Closeable {
  def load(): Unit = {}
  def delete(): Unit = {}
  def close(): Unit = {}
  def closeAfter(interval: FiniteDuration): Unit = {
    IO.closeAfter(this, interval)
  }
}

trait ExpiringWizardResource extends WizardResource {
  def freshness: Long

  def isAlive(ttl: FiniteDuration): Boolean = System.currentTimeMillis() < freshness + ttl.toMillis
}
