package ru.yandex.tours.wizard.resource

import java.io.File

import ru.yandex.tours.util.Logging

import scala.util.{Failure, Success, Try}

/**
  * Created by asoboll on 26.01.17.
  */
trait WizardResourceLoader[+R <: WizardResource] extends Logging {
  import WizardResourceLoader._

  def empty: R

  def fromFile(file: File): R

  def allFiles(dir: File, extension: String): Vector[FileShard[R]] = {
    require(dir.exists() || dir.mkdirs(), s"[$dir] does not exists")
    log.info(s"Loading $extension files from directory [$dir]")
    val shards = Vector.newBuilder[FileShard[R]]

    for (file <- dir.listFiles() if file.getName.endsWith(extension)) {
      Try(fromFile(file)) match {
        case Success(shard) =>
          shards += FileShard[R](file, shard)
        case Failure(t) =>
          log.warn(s"Skipped invalid shard $file", t)
      }
    }
    shards.result()
  }

  def allFromDir(dir: File, extension: String): Vector[R] =
    allFiles(dir, extension).map(_.shard)
}

object WizardResourceLoader {
   case class FileShard[+R <: WizardResource] (file: File, shard: R)
}
