#!/bin/sh

. ./component.sh

JAVA_HOME=/usr/local/java8
PATH="$JAVA_HOME/bin:$PATH"
LANG=ru_RU.UTF8
LOG_DIR=.
PID_FILE=../$DAEMON.pid

CLASSPATH=`find lib -name '*.jar' -printf '%p:'`$CLASSPATH

export PATH LANG JAVA_HOME CLASSPATH
#-agentpath:./libyjpagent.so \

java -classpath $CLASSPATH  \
     -Dfile.encoding=UTF8 \
     -Doracle.net.tns_admin=/etc/oracle \
     -showversion -server -Xverify:none \
     -Xmx2048m -Xms2048m \
     -Xmn1024m \
     -XX:+AlwaysPreTouch \
     -XX:+UseParNewGC \
     -XX:ParallelGCThreads=4 \
     -XX:+UseConcMarkSweepGC \
     -XX:MaxTenuringThreshold=1 \
     -XX:SurvivorRatio=63 \
     -XX:+CMSScavengeBeforeRemark \
     -XX:CMSInitiatingOccupancyFraction=75 \
     -XX:+UseCMSInitiatingOccupancyOnly \
     -XX:+CMSParallelRemarkEnabled \
     -XX:+UseTLAB \
     -XX:+UseCondCardMark -XX:+UseNUMA \
     -XX:+HeapDumpOnOutOfMemoryError \
     -XX:HeapDumpPath=$HPROF_DIR \
     -XX:OnOutOfMemoryError="echo on oom killing process %p; kill -9 %p" \
     -Xloggc:$GC_LOG \
     -XX:+PrintCommandLineFlags \
     -XX:+PrintGCApplicationStoppedTime \
     -XX:+PrintGCDetails \
     -XX:+PrintGCDateStamps \
     -XX:+PrintGCCause \
     -XX:+PrintPromotionFailure \
     -XX:+PrintGCApplicationStoppedTime \
     -Dhost.name=`/bin/hostname --fqdn` \
     -Djava.net.preferIPv6Addresses=true \
     -Dsun.net.client.defaultConnectTimeout=10000 \
     -Dsun.net.client.defaultReadTimeout=10000 \
     -Dsun.net.inetaddr.ttl=86400 -Dhttp.keepAlive=false \
     -Dlogging.path=$LOG_DIR \
     ru.yandex.tours.WizardMain >> $LOG_DIR/$DAEMON.log.shell 2>&1 &

echo $! > $PID_FILE