package ru.yandex.tours

import java.io.File

import akka.actor.Props
import ru.yandex.common.pusher.PusherExtension
import ru.yandex.tours.app.{AkkaSupport, Application, ZookeeperSupport}
import ru.yandex.tours.extdata.ExtDataSupport
import ru.yandex.tours.index.WizardIndexing.MicroOffers
import ru.yandex.tours.index.{IndexCleaner, WizardIndexing}
import ru.yandex.tours.util.file._
import ru.yandex.tours.wizard.microoffer.{FreshMicroOfferHolder, LongMicroOfferHolder, MicroOfferIndexImpl}
import ru.yandex.tours.wizard.resource.ResourceReceiver

import scala.concurrent.duration._

/**
  * Created by asoboll on 14.02.17.
  */
trait WizardMicroOffersSupport { app: Application with AkkaSupport with ZookeeperSupport with ExtDataSupport =>

  private val dir = new File(app.config.getString("tours.wizard.offers.dir"))

  private val freshDir = dir / "fresh"
  private val longDir = dir / "long"

  private val freshTTL = 20.minutes
  private val longTTL = 24.hours

  lazy val freshOffers = FreshMicroOfferHolder.fromDirectory("fresh", freshDir, freshTTL)
  lazy val longOffers = LongMicroOfferHolder("long", longDir, extDataService, extDataUpdateChecker)

  lazy val microOffersReceiver = akkaSystem.actorOf(Props(
    new ResourceReceiver(freshOffers, MicroOfferIndexImpl, freshDir, "microOffers")))

  onStart {
    PusherExtension(akkaSystem)
      .newSubscriber(MicroOffers.topic, microOffersReceiver, app.dataCenter, zkClient, WizardIndexing.zkPath)

    IndexCleaner.start(freshDir, MicroOffers.extension, freshTTL, 1.hour)(akkaSystem)
    IndexCleaner.start(longDir, MicroOffers.extension, longTTL, 1.hour)(akkaSystem)

    freshOffers.startMonitoring(isCritical = false)(akkaSystem)
    longOffers.startMonitoring(isCritical = false)(akkaSystem)
  }
}
