package ru.yandex.tours.wizard

import ru.yandex.tours.model.utm.UtmMark

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 18.03.15
 */
case class WizardType(`type`: String, context: String = "", counter: String = "") {
  def utm = UtmMark.empty
    .withSource("wizard")
    .withCampaign(`type`)
    .withMedium(context)

  override def toString: String = `type`

  def getCounter = "/snippet/" + (if (counter.nonEmpty) counter else `type`)
}
