package ru.yandex.tours.wizard

import akka.actor.ActorSystem
import ru.yandex.tours.geo.mapping.GeoMappingHolder
import ru.yandex.tours.hotels.HotelsIndex
import ru.yandex.tours.util.Logging
import ru.yandex.tours.wizard.index.IndexHolder

import scala.concurrent.duration.FiniteDuration

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 12.11.15
 */
class WizardWarmer(hotelsIndex: HotelsIndex, geoMapping: GeoMappingHolder, freshIndex: IndexHolder, longIndex: IndexHolder)
  extends Runnable with Logging {

  def warmIndex(indexHolder: IndexHolder): Unit = {
    log.info(s"Warming up $indexHolder")
    for (e <- freshIndex.getIndex.iterator) {}
  }

  def run(): Unit = {
    if (freshIndex.size > 0) warmIndex(freshIndex)
    else warmIndex(longIndex)

    log.info("Warming hotels by regions")
    for (geoId <- geoMapping.countryGeoIds ++ geoMapping.cityGeoIds) {
      hotelsIndex.topInRegion(geoId, 3)
    }
    log.info("Warming hotels by id")
    for (hotel <- hotelsIndex.hotels) {
      hotelsIndex.getHotelById(hotel.id)
    }
    log.info("Warming complete")
  }

  def schedule(interval: FiniteDuration)(implicit akkaSystem: ActorSystem) = {
    akkaSystem.scheduler.schedule(interval, interval, this)(akkaSystem.dispatcher)
  }
}
