package ru.yandex.tours.wizard.domain

/**
  * Author: Vladislav Dolbilov (darl@yandex-team.ru)
  * Created: 02.12.16
  */
object Relevance {

  private val TOP1_RELEV = 0.6d
  private val TOP3_RELEV = 0.25d
  private val TOP5_RELEV = 0.2d
  private val TOP10_RELEV = 0.1d

  //https://st.yandex-team.ru/BLNDR-312
  def apply(request: ToursWizardRequest, response: ToursWizardResponse): Double = {
    import request._

    val isRoomsResponse = response.isInstanceOf[RoomsResponse] || response.isInstanceOf[RoomDirectionsResponse]
    if (response.isInstanceOf[SkiResortResponse]) {
      TOP3_RELEV
    } else if (isRoomsResponse) {
      if (response.isInstanceOf[RoomsResponse]) {
        if (hasHotelMarker) {
          TOP1_RELEV
        } else {
          TOP10_RELEV
        }
      } else {
        if (hotelTypesFilter.isEmpty) TOP1_RELEV
        else TOP3_RELEV
      }
    } else if (hotel.isDefined) {
      if (hasMarker || hotelOnTop) TOP1_RELEV
      else if (hasOfficialSiteMarker) TOP10_RELEV
      else TOP3_RELEV
    } else {
      if (to.isEmpty) {
        if (operator.isEmpty) {
          //общий поиск "поиск туров"
          TOP1_RELEV
        } else {
          //есть туроператор
          if (hasMarker) TOP3_RELEV
          else TOP5_RELEV
        }
      } else {
        if (operator.isEmpty) {
          //поиск по направлению
          if (hasMarker) TOP1_RELEV
          else if (hasHotelMarker) TOP3_RELEV
          else TOP10_RELEV
        } else {
          //оператор + направление
          TOP3_RELEV
        }
      }
    }
  }

}
