package ru.yandex.tours.wizard.domain

import org.joda.time.LocalDate
import ru.yandex.tours.query.DateInterval
import ru.yandex.tours.util.lang.Dates._

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 06.02.15
 */
case class TourStartInterval(from: LocalDate, until: LocalDate)

object TourStartInterval {

  def default(hot: Boolean) = {
    val now = LocalDate.now()
    if (hot) {
      // TourStartInterval(now, now.plusDays(14))
      TourStartInterval(now, now.plusMonths(3)) // prefer cheap tours instead
    } else {
      val saturday = now.nextSaturday
      TourStartInterval(saturday, saturday.plusMonths(3))
    }
  }

  def fromDateInterval(dateInterval: DateInterval, now: LocalDate = LocalDate.now) = {
    val currYear = now.getYear
    val year =
      if (dateInterval.until.toLocalDate(currYear).isBefore(now)) currYear + 1
      else currYear

    val baseFrom = dateInterval.from.toLocalDate(year)
    val until = dateInterval.until.toLocalDate(year)

    val from =
      if (baseFrom.isAfter(until)) baseFrom.minusYears(1)
      else baseFrom

    TourStartInterval(from, until)
  }
}
