package ru.yandex.tours.wizard.experiment

import org.apache.curator.framework.CuratorFramework
import ru.yandex.tours.util.Logging
import ru.yandex.tours.util.zoo.{StringSetSerializer, BooleanSerializer, SharedValue}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 13.05.15
 */
class ExperimentControl(zkClient: CuratorFramework) extends Logging {
  private val shared = new SharedValue[Set[String]](zkClient, "/wizard/exp/enabled", Set.empty, StringSetSerializer)

  shared.onUpdate(update)

  def update(enabled: Set[String]): Unit = {
    log.info("Enabled experiments: " + enabled.mkString(", "))
    if (shared.get != enabled) shared.set(enabled)
    WizardExperiment.enabledExperiments = enabled
  }

  def enable(experiment: String): Unit = {
    update(shared.get + experiment)
  }

  def disable(experiment: String): Unit = {
    update(shared.get - experiment)
  }
}
