package ru.yandex.tours.wizard.experiment

import ru.yandex.tours.util.Logging
import ru.yandex.tours.wizard.WizardType

import scala.util.hashing.MurmurHash3

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 13.05.15
 *
 * NOTE: user's bucket stored in Thread local variable
 */
object WizardExperiment extends Logging {

  private val uid = new ThreadLocal[String]
  private val currentExperiment = new ThreadLocal[String]

  var enabledExperiments = Set.empty[String]

  def getUid: String = this.uid.get
  def update(uid: String): Unit = {
    this.uid.set(uid)
  }

  def isUnderExperiment(exp: String): Boolean = {
    if (enabledExperiments.contains(exp)) {
      if (currentExperiment.get eq null) {
        currentExperiment.set(exp)
      }
      getBucket(exp) == 0
    } else {
      false
    }
  }

  def getBucket(exp: String) = {
    (MurmurHash3.stringHash(uid.get + "_" + exp) % 3).abs
  }

  def getCurrentExperiment = {
    val exp = currentExperiment.get()
    if (exp ne null) exp
    else ""
  }

  def getBucketName: String = {
    if (currentExperiment.get() eq null) ""
    else getBucket(currentExperiment.get()) match {
      case 0 => "exp"
      case 1 => "c1"
      case 2 => "c2"
    }
  }

  def logResponse(wizardType: WizardType) = {
    if (currentExperiment.get() ne null) {
      log.info(s"experiment=${currentExperiment.get} bucket=$getBucketName type=$wizardType")
    }
  }

  def clear(): Unit = {
    currentExperiment.remove()
    uid.remove()
  }

}
