package ru.yandex.tours.wizard.geoaddr

import ru.yandex.tours.geo.base.region

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 30.01.15
 */
case class GeoAddr(objects: GeoAddrObject*)

case class GeoAddrObject(variants: Seq[GeoVariant],
                         bestGeo: Int,
                         rawName: String,
                         normalizedName: String,
                         position: Int, length: Int)

case class GeoVariant(geoId: Seq[Int], `type`: region.Type, weight: Double)

object GeoAddr {
  def empty: GeoAddr = GeoAddr()
}