package ru.yandex.tours.wizard.geoaddr

import ru.yandex.tours.geo.mapping.GeoMappingHolder
import ru.yandex.tours.query.{SomeRegion, GeoRegion}
import ru.yandex.tours.util.text.StringNormalizer
import ru.yandex.tours.wizard.query._

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 04.02.15
 */
class GeoAddrPragmatics(geoMappingHolder: GeoMappingHolder) {

  def translate(userRequest: String, geoAddr: GeoAddr): Seq[ParsedUserQuery.QueryPart] = {
    val normalizedRequest = StringNormalizer.normalizeString(userRequest)
    for {
      geoObj <- geoAddr.objects
      name = StringNormalizer.normalizeString(geoObj.rawName)
      index = normalizedRequest.indexOf(name)
      if index >= 0
      pragmatic <- translateObject(geoObj)
    } yield {
      ParsedUserQuery.QueryPart(
        normalizedRequest,
        index,
        index + name.length,
        pragmatic
      )
    }
  }

  def translateObject(geoObj: GeoAddrObject): Option[GeoRegion] = {
    if (geoObj.bestGeo > 0) return Some(SomeRegion(geoObj.bestGeo))

    def knownGeoId(variant: GeoVariant): Seq[Int] = variant.geoId.filter(geoId => geoMappingHolder.isKnownDestination(geoId) || geoMappingHolder.isDepartureCity(geoId))

    val knownIds = geoObj.variants.sortBy(_.weight).flatMap(knownGeoId)

    for (regionId <- knownIds.headOption)
    yield SomeRegion(regionId)
  }

}
