package ru.yandex.tours.wizard.index

import ru.yandex.tours.index.WizardIndex
import ru.yandex.tours.wizard.resource.{MonitoredResourceHolder, ResourceHolder}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 24.03.15
 */
trait IndexHolder extends ResourceHolder[WizardIndex] {
  def getIndex: WizardIndex = getResource
  def size: Int
}

trait MonitoredIndexHolder extends IndexHolder with MonitoredResourceHolder {
  def name: String
  def monPath: String = s"index.$name"
  def resoureName: String = s"Index [$name]"
  def isEmpty: Boolean = getResource.iterator.isEmpty
}